//
//  YHActivateHKVisaCell.swift
//  galaxy
//
//  Created by edy on 2024/8/22.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHActivateHKVisaCell: UITableViewCell {

    static let cellReuseIdentifier = "YHActivateHKVisaCell"

    // 此处index 是按钮从左到右由0开始
    var isAllGo:Bool = true {
        didSet {
            var selectIndex = isAllGo ? 0 : 1
            optionView.selectIndex = selectIndex
        }
    }
    
    var selectBlock:((_ isAllGo: Bool)->())?
    
    lazy var whiteContentView: UIView = {
        let view = UIView()
        view.backgroundColor = .white
        view.layer.cornerRadius = kCornerRadius6
        return view
    }()
    
    lazy var titleLabel: UILabel = {
        let label = UILabel()
        label.numberOfLines = 0
        let a: ASAttributedString = .init("*", .font(UIFont.PFSC_M(ofSize: 17)),.foreground(UIColor.failColor))
        let b: ASAttributedString = .init("赴港激活签证", .font(UIFont.PFSC_M(ofSize: 17)),.foreground(UIColor.mainTextColor))
        label.attributed.text = a+b
        return label
    }()
    
    lazy var lineView: UIView = {
        let view = UIView()
        view.backgroundColor = .separatorColor
        return view
    }()
    
    lazy var optionView: YHInfoItemOptionView = {
        let view = YHInfoItemOptionView(frame: .zero)
        view.title = "申请人是否统一赴港激活签证"
        view.options = ["是", "否"]
        view.selectIndex = 0
        view.selectBlock = {
            [weak self] index in
            guard let self = self else { return }
            let isAllGo = index == 0 ? true : false
            self.selectBlock?(isAllGo)
        }
        return view
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        self.backgroundColor = .clear
        self.contentView.backgroundColor = .clear
        contentView.addSubview(whiteContentView)
        whiteContentView.addSubview(titleLabel)
        whiteContentView.addSubview(lineView)
        whiteContentView.addSubview(optionView)
        
        whiteContentView.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.bottom.equalTo(0)
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(16)
            make.left.equalTo(18)
            make.right.equalTo(-18)
        }
        
        lineView.snp.makeConstraints { make in
            make.top.equalTo(titleLabel.snp.bottom).offset(12)
            make.left.right.equalToSuperview()
            make.height.equalTo(0.5)
        }
        
        optionView.snp.makeConstraints { make in
            make.top.equalTo(lineView.snp.bottom).offset(0)
            make.left.equalTo(18)
            make.right.equalTo(-18)
            make.bottom.equalTo(0)
        }
    }

}
